package nl.umcg.deelenp.annotateintersectionoverview.annotations.sources;

import java.io.FileNotFoundException;
import java.io.IOException;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSourcePosition;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.IntProperty;
import nl.umcg.deelenp.sequecingfamilyintersection.GenomicBoundaries;

/**
 *
 * @author PatrickDeelen
 */
public class GenomicsBoundaryAnnotation implements AnnotationSourcePosition {

    private GenomicBoundaries genomicBoundaries;
    private String[] annotationHeaders;
    private static final int numberOfAnnotationProperties = 1;

    public GenomicsBoundaryAnnotation(String genomicsBoundarysFilePath, String boundariesName) throws FileNotFoundException, IOException {

        this(genomicsBoundarysFilePath, boundariesName, 0);

    }

    public GenomicsBoundaryAnnotation(String genomicsBoundarysFilePath, String boundariesName, int margin) throws FileNotFoundException, IOException {

        genomicBoundaries = new GenomicBoundaries(genomicsBoundarysFilePath, margin);
        annotationHeaders = new String[numberOfAnnotationProperties];
        annotationHeaders[0] = boundariesName;

    }

    public String[] getAnnotationHeaders() {
        return annotationHeaders;
    }

    public AnnotationProperty[] getAnnotationForPosition(String chromosome, int position) {
        
        AnnotationProperty[] annotations = new AnnotationProperty[numberOfAnnotationProperties];
        
        if(genomicBoundaries.isInBoundary(chromosome, position)){
            annotations[0] = new IntProperty(1);
        }

        return annotations;
        
    }

    public int getNumberOfAnnotationProperties() {
        return numberOfAnnotationProperties;
    }

    

}
