package nl.umcg.deelenp.annotateintersectionoverview.writers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jxl.Workbook;
import jxl.write.Number;

import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSource;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSourcePosition;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.DoubleProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.IntProperty;

/**
 *
 * @author PatrickDeelen
 */
public class XlsAnnotationWriter implements AnnotationWriter{

    private WritableWorkbook overviewWorkbook;
    private boolean skipFirstSheet;
    private boolean closed = false;

    public XlsAnnotationWriter(String sourceFilePath, String targetFilePath, boolean skipFirstSheet) throws IOException, BiffException, Exception {
        this.skipFirstSheet = skipFirstSheet;

        if(sourceFilePath.equals(targetFilePath)){
            throw new Exception("Source and target file path for annotation are identical");
        }

        Workbook workbook = Workbook.getWorkbook(new File(sourceFilePath));

        overviewWorkbook = Workbook.createWorkbook(new File(targetFilePath), workbook);
        workbook.close();
        
    }

    public void addAnnotations(ArrayList<AnnotationSource> annotations) throws Exception {

        if(closed){
            throw new Exception("Writer already closed");
        }
        
        WritableSheet[] sheets = overviewWorkbook.getSheets();

        for(int i = skipFirstSheet?1:0 ; i < sheets.length ; ++i){
            WritableSheet sheet = sheets[i];

            int firstAnnotationColumn = sheet.getColumns();

            int column = firstAnnotationColumn;
            for(AnnotationSource annotation : annotations){

                for(String header : annotation.getAnnotationHeaders()){
                     sheet.addCell(new Label(column, 0, header));
                    ++column;
                }
            }

            for(int row = 1 ; row < sheet.getRows() ; ++row){

                column = firstAnnotationColumn;

                String chromosome = sheet.getCell(2 ,row).getContents();
                int position = Integer.parseInt(sheet.getCell(3, row).getContents());

                for(AnnotationSource annotation : annotations){

                    AnnotationProperty[] properties;
                    if(annotation.getClass() == AnnotationSourcePosition.class){
                        properties = ((AnnotationSourcePosition)annotation).getAnnotationForPosition(chromosome, position);
                    } else {
                        continue;
                    }

                    for(AnnotationProperty property : properties){

                        if(property != null){
                            
                            if(property.getClass() == IntProperty.class){
                                sheet.addCell(new Number(column, row, ((IntProperty)property).getPropertyValue()));
                            } else if (property.getClass() == DoubleProperty.class){
                                sheet.addCell(new Number(column, row, ((DoubleProperty)property).getPropertyValue()));
                            } else {
                                sheet.addCell(new Label(column, row, property.getProperty()));
                            }
                        }

                        ++column;
                        
                    }
                }
            }
        }
     }

    public void close() throws Exception {
        overviewWorkbook.write();
        overviewWorkbook.close();
        closed = true;
    }

}
