/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package nl.umcg.deelenp.annotateintersectionoverview.writers;

import java.util.ArrayList;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSource;

/**
 *
 * @author PatrickDeelen
 */
public interface AnnotationWriter {

    /**
     * Add a annotations to a file. Can not be called after the writer has
     * been closed
     *
     * @param annotations ArrayList with annotation sources
     * @throws Exception
     */
    public void addAnnotations(ArrayList<AnnotationSource> annotations) throws Exception;

    /**
     * Closes the file. Must be called to write the data. Subsequential calls
     * to addAnnotations are not allowed.
     *
     * @throws Exception if closing or writing fails
     */
    public void close() throws Exception;

}
