/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package nl.umcg.deelenp.annotateintersectionoverview;

import java.util.ArrayList;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSource;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.PropertyTypes;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.sources.AnnotationSourceColumn;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.sources.EQtlAnnotations;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.sources.GenomicsBoundaryAnnotation;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.sources.GenotypingChipAnnotation;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.sources.SeparetedTextAnnotations;
import nl.umcg.deelenp.annotateintersectionoverview.writers.AnnotationWriter;
import nl.umcg.deelenp.annotateintersectionoverview.writers.SeparatedTextAnnotationWriter;
import nl.umcg.deelenp.sequecingfamilyintersection.Sample;
import nl.umcg.deelenp.sequecingfamilyintersection.SampleSet;

/**
 *
 * @author PatrickDeelen
 */
public class Annotate {

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws Exception {

//        AnnotationWriter annotationWriter = new XlsAnnotationWriter(
//                "/data/Celiac40ExomsProject/IntersectionOutput/test3/geneOverview.xls",
//                "/data/Celiac40ExomsProject/IntersectionOutput/test3/geneOverview-annotate.xls",
//                true);


        ArrayList<AnnotationSource> annotationSources = new ArrayList<AnnotationSource>();

        annotationSources.add(new EQtlAnnotations("/data/Celiac40ExomsProject/eQTLsFDR0.05.txt"));
        annotationSources.add(new GenomicsBoundaryAnnotation("/data/Celiac40ExomsProject/celiacLoci.txt", "Celiac loci"));
        annotationSources.add(new GenomicsBoundaryAnnotation("/data/Celiac40ExomsProject/celiacLoci.txt", "Celiac Loci + 500kb", 500000));
        annotationSources.add(new GenomicsBoundaryAnnotation("/data/Celiac40ExomsProject/celiacLinkageRegions.txt", "Celiac Linkage"));
        annotationSources.add(new GenomicsBoundaryAnnotation("/data/Celiac40ExomsProject/immunochipLoci.txt", "Immunochip Loci"));
        annotationSources.add(new GenotypingChipAnnotation("/data/Celiac40ExomsProject/ImmunochipSnps.txt", "Immunochip"));

        ArrayList<AnnotationSourceColumn> columns = new ArrayList<AnnotationSourceColumn>();

        columns.add(new AnnotationSourceColumn(0, PropertyTypes.STRING, "Source_SeattleSeq"));
        columns.add(new AnnotationSourceColumn(9, PropertyTypes.STRING, "Function DB-SNP"));
        columns.add(new AnnotationSourceColumn(13, PropertyTypes.STRING, "PolyPhen"));
        columns.add(new AnnotationSourceColumn(15, PropertyTypes.STRING, "scorePhastCons"));
        columns.add(new AnnotationSourceColumn(16, PropertyTypes.STRING, "consScoreGERP"));
        columns.add(new AnnotationSourceColumn(18, PropertyTypes.STRING, "CNV"));


        SampleSet samples = new SampleSet("/data/Celiac40ExomsProject/familyStructure.txt");


        for(Sample sample : samples){
            String sampleId = sample.getSampleId();


            annotationSources.add(new SeparetedTextAnnotations("/home/genetica/agata/Agata_immunochp/"+sampleId+".snp.Q20.alleleCorrection.autoFile.SeattleOutput.removeDuplicates.immunochip.dbSNP.txt",
                "\\t", false, columns, 1, 2, false));


            AnnotationWriter annotationWriter = new SeparatedTextAnnotationWriter("/data/Celiac40ExomsProject/SequencingAnnotation/"+sampleId+".snp.Q20.gff", "/data/Celiac40ExomsProject/SequencingAnnotation/"+sampleId+".snp.Q20.gff.annotated", false, "\t", 0, 3, -1);
            annotationWriter.addAnnotations(annotationSources);

            annotationWriter.close();

            annotationSources.remove(annotationSources.size()-1);

        }
        

    }

}
