package nl.umcg.deelenp.annotateintersectionoverview.annotations.sources;

import java.io.FileNotFoundException;
import java.io.IOException;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationProperty;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.AnnotationSourcePosition;
import nl.umcg.deelenp.annotateintersectionoverview.annotations.properties.IntProperty;
import nl.umcg.deelenp.genotypeChips.ChipSnps;

/**
 *
 * @author PatrickDeelen
 */
public class GenotypingChipAnnotation implements AnnotationSourcePosition {

    private ChipSnps chipSnps;
    private String[] annotationHeaders;
    private static final int numberOfAnnotationProperties = 1;

    public GenotypingChipAnnotation(String filePath, String chipName) throws FileNotFoundException, IOException {

        chipSnps = new ChipSnps(filePath);
        annotationHeaders = new String[numberOfAnnotationProperties];
        annotationHeaders[0] = chipName;

    }

    public String[] getAnnotationHeaders() {
        return annotationHeaders;
    }

    public AnnotationProperty[] getAnnotationForPosition(String chromosome, int position) {

        AnnotationProperty[] annotations = new AnnotationProperty[numberOfAnnotationProperties];

        if(chipSnps.containsSnp(chromosome, position)){
            annotations[0] = new IntProperty(1);
        }

        return annotations;

    }

    public int getNumberOfAnnotationProperties() {
        return numberOfAnnotationProperties;
    }

}
